/****************************************************************************
*
*  File      PEMDLL.h                                                          
*  
*  Brief     Soliton PETS PCI-E Test System Library
*                                                                       
*  Author    wit
*
*  Version   v3.30
*
*  Date      2013/09/12
*
*  Revision history:
*  -------------------------------------------------------------------------
*  Num.     When            By whom         
*  -------------------------------------------------------------------------
*  1.       2013/09/12     wit@soliton     
*    Add SVID/SDID Check/Access Function
*    a. SELDEV(Vid, Did, Svid, Sdid, index) : 
*       when select device with Svid/Sdid, VALIDDEV will check Svid/Sdid 
*		 b. GETDEVHWVID() : Get Current PCI-E Device VID
*		 c. GETDEVHWDID() : Get Current PCI-E Device DID
*    d. GETDEVHWSVID() : Get Current PCI-E Device SVID
*    e. GETDEVHWSDID() : Get Current PCI-E Device SVID
*    f. GETPCIDEVSVID() : PETs initialial Scanned Device SVID
*    g. GETPCIDEVSDID() : PETs initialial Scanned Device SDID
*
*  Copyright (c) 2013 Soliton Technologies  All rights reserved.                              
*
*****************************************************************************/
#ifdef PEMDLL_EXPORTS
#define PEMDLL_API __declspec(dllexport)
#else
#define PEMDLL_API __declspec(dllimport)
#endif

#define CPEMDLL_SUCESS				0 
#define CPEMDLL_FAIL				1
#define CPEMDLL_ERROR_PEMNOTEXIST	2
#define CPEMDLL_ERROR_ADCNOTEXIST	3
#define CPEMDLL_ERROR_POWERFAIL		4
#define CPEMDLL_ERROR_DEVNOTEXIST	5
#define CPEMDLL_ERROR_DEVNOTMATCH	6
#define CPEMDLL_ERROR_DEVNEEDCFG	7

#define CPEMDLL_ERROR_3V3AUXSHORT	0x04
#define CPEMDLL_ERROR_3V3SHORT		0x02
#define CPEMDLL_ERROR_1V5SHORT		0x01

#define PEMCTRL_ERROR_3V3AUXSHORT	0x01
#define PEMCTRL_ERROR_3V3SHORT		0x02
#define PEMCTRL_ERROR_1V5SHORT		0x04

//!#00C0: IO Conttrol FOR PEM IOM V1.01
#define CPEMDLL_ERROR_IOMNOTEXIST	0x80
#define CPEMDLL_ERROR_IOMISINPUT	0x81

enum{
	CPEMDLL_PEMIO_PERSTn,		// 0
	CPEMDLL_PEMIO_CLKREQn,
	CPEMDLL_PEMIO_WAKEn,
	CPEMDLL_PEMIO_LED_WWANn,
	CPEMDLL_PEMIO_LED_WLANn,
	CPEMDLL_PEMIO_LED_WPANn,
	CPEMDLL_PEMIO_RS_PIN3,
	CPEMDLL_PEMIO_RS_PIN5,
	CPEMDLL_PEMIO_RS_PIN20,		// 8
	CPEMDLL_PEMIO_UIM_RESET,
	CPEMDLL_PEMIO_UIM_CLK,
	CPEMDLL_PEMIO_UIM_DATA,
	CPEMDLL_PEMIO_UIM_VPP,
	CPEMDLL_PEMIO_UIM_PWR,		// 13
	CPEMDLL_PEMIO_RS_PIN17,		//
	CPEMDLL_PEMIO_RS_PIN19,		// 
	CPEMDLL_PEMIO_RS_PIN45,		//16
	CPEMDLL_PEMIO_RS_PIN47,
	CPEMDLL_PEMIO_RS_PIN49,
	CPEMDLL_PEMIO_RS_PIN51
};
// This class is exported from the PEMDll.dll
class PEMDLL_API CPEMDll 
{
	public:
		CPEMDll(void);
		char CPEMDLL_PEMIO_Name[24][16];
		
		int INIT();
		int INIT(int comport);
		int INITEX();
		int INITEX(DWORD addr);
		int EXIT();
		int VALIDPEM(DWORD addr);
		int SELPEM(DWORD addr);

		int GETPNTYPE();
		int VALIDDEV();	
		int SELDEV(DWORD Vid, DWORD Did, int index);
		int SELDEV(DWORD Vid, DWORD Did, DWORD Svid, DWORD Sdid, int index);		//2013/09/12 Add
		int SELDEV(DWORD Busno, DWORD Devno);
		int PON();
		int POFF();
		int GETPWRSTS();
		int CHKSHORT();
		int GET3V3V(double* volatge);
		int GET1V5V(double* volatge);
		int GET12V(double* volatge);
		int GET3V3I(double* current);
		int GET1V5I(double* current);
		int GET3V3IMAX(double* current);	//!#0004
		int GET1V5IMAX(double* current);	//!#0004
		int GET12I(double* volatge);
		int GETTEMP(DWORD devaddr, double* temp);	//!#0003

		int SET1V5ICAL();
		int SET3V3ICAL();
		int SET12ICAL();
		int SETUSECAL(int i);
		int GETUSECAL();

		int WINCHECK();
		int WINEN(int delaytime);
		int WINDIS(int delaytime);
		int CHECKCFG(char* logfile);
		int WAITCARDREMOVE();
		int WAITCARDPLUG();
		int CHECKCD();	//!#0005
		int LEDGO();
		int LEDNG();
		int LEDOFF();
		int BEEP(int freq, int time);
		int SETPONRST(int setting);	//!#0004

		int GETPNTYPE(DWORD addr);
		int VALIDDEV(DWORD addr);
		int SELDEV(DWORD addr, DWORD Vid, DWORD Did, int index);
		int SELDEV(DWORD addr, DWORD Busno, DWORD Devno);
		int GETPWRSTS(DWORD addr);
		int CHKSHORT(DWORD addr);
		int GET3V3V(DWORD addr, double* volatge);
		int GET1V5V(DWORD addr, double* volatge);
		int GET12V(DWORD addr, double* volatge);
		int GET3V3I(DWORD addr, double* current);
		int GET1V5I(DWORD addr, double* current);
		int GET3V3IMAX(DWORD addr, double* current);	//!#0004
		int GET1V5IMAX(DWORD addr, double* current);	//!#0004
		int GETTEMP(DWORD addr, DWORD devaddr, double* temp); //!#0003

		int GET12I(DWORD addr, double* current);
		int SET1V5ICAL(DWORD addr); 

		int SET3V3ICAL(DWORD addr);
		int SET12ICAL(DWORD addr);
		int SETUSECAL(DWORD addr, int i);
		int GETUSECAL(DWORD addr);

		int PON(DWORD addr);
		int POFF(DWORD addr);
		int WINCHECK(DWORD addr);
		int WINEN(DWORD addr, int delaytime);
		int WINDIS(DWORD addr, int delaytime);
		int CHECKCFG(DWORD addr, char* logfile);
		int WAITCARDREMOVE(DWORD addr);
		int WAITCARDPLUG(DWORD addr);
		int CHECKCD(DWORD addr);	//!#0005
		int LEDGO(DWORD addr);
		int LEDNG(DWORD addr);
		int LEDOFF(DWORD addr);
		int BEEP(DWORD addr, int freq, int time);
		int SETPONRST(DWORD addr, int setting);	//!#0004

		void GETLIBVER(int* major, int* minor);
		int GETPCIDEVCOUNT();
		int SELPCIDEV(int num);
		char* GETPCIDEVDESC();
		DWORD GETPCIDEVVID();
		DWORD GETPCIDEVDID();
		DWORD GETPCIDEVBUSNO();
		DWORD GETPCIDEVDEVNO();
		//2013/09/12, Add
		DWORD GETPCIDEVSVID();	
		DWORD GETPCIDEVSDID();	
		
		DWORD GETDEVHWVID();
		DWORD GETDEVHWDID();
		DWORD GETDEVHWSVID();
		DWORD GETDEVHWSDID();		
		DWORD GETDEVHWVID(DWORD addr);
		DWORD GETDEVHWDID(DWORD addr);
		DWORD GETDEVHWSVID(DWORD addr);
		DWORD GETDEVHWSDID(DWORD addr);		
		//2013/09/12, Add End
				
		int GPIOSETUP(int pinno, int mode, int val);
		int GPIOOUTSET(int pinno);
		int GPIOOUTRESET(int pinno);
		int GPIOIN(int pinno);
		int GPIOGETSETUP(int pinno);

		int GPIOSETUP(DWORD addr, int pinno, int mode, int val);
		int GPIOOUTSET(DWORD addr, int pinno);
		int GPIOOUTRESET(DWORD addr, int pinno);
		int GPIOIN(DWORD addr, int pinno);
		int GPIOGETSETUP(DWORD addr, int pinno);

		//!#0009, Mar/09/2007
		int PROBESMBCLKRISE(double* time);
		int PROBESMBCLKRISE(DWORD addr, double* time);

		//!#000A, Apr/18/2007, Vincent
		int GET5V(double* volatge);
		int GET5VI(double* current);
		int GET5VIMAX(double* current);	
		int GET5V(DWORD addr, double* volatge);
		int GET5VI(DWORD addr, double* current);
		int GET5VIMAX(DWORD addr, double* current);
		int usecomport;

		int WINEN2(DWORD addr, int delaytime);
		int WINEN2(int delaytime);
		int DEVRESCAN(int delaytime);

		int RESETLINKEDDEVICECOUNT();
		int ADDLINKEDDEVICEFUNC(unsigned long busnoi, unsigned long devnoi, unsigned long funcnoi);
		int UPDATELINKEDDEVICE();

		int RESETLINKEDDEVICECOUNT(DWORD addr);
		int ADDLINKEDDEVICEFUNC(DWORD addr, unsigned long busnoi, unsigned long devnoi, unsigned long funcnoi);
		int UPDATELINKEDDEVICE(DWORD addr);
		//!#00B1, May/07/2008, Add
		int GETFIRMVER(DWORD addr, int* major, int* minor);
		int GETFIRMVER(int* major, int* minor);
		//!#00B2, Jun/05/2008, Add
		int PWRCTL_AUTO();
		int PWRCTL_MANUAL();
		int PWRCTL_AUTO(DWORD addr);
		int PWRCTL_MANUAL(DWORD addr);

		//!#00C1: IO Conttrol FOR PEM IOM V1.01
		int IOMINIT();
		int IOMGETPINOE(int pinno);
		int IOMGETPINIE(int pinno);
		int IOMSETPINOE(int pinno);
		int IOMSETPINIE(int pinno);
		int IOMSETPIN(int pinno, int hilo);
		int IOMGETPIN(int pinno);
		char* IOMGETPINNAME(int pinno);
		int IOMSETPINPU(int pinno, int hilo);
		int IOMGETPINPU(int pinno);

		int IOMSETOE(unsigned long val);
		int IOMSETIO(unsigned long val);
		int IOMSETPU(unsigned long val);
		int IOMGETIO(unsigned long *val);
		int IOMGETPU(unsigned long *val);
		int IOMGETOE(unsigned long *val);

		//!#00C1, Mar/05/2012, Vincent
		int PEX3V3AUXONWHENPOFF();
		int PEX3V3AUXOFFWHENPOFF();
		// !#00C2: 08/08/2012		
		int SELDEV(DWORD Busno, DWORD Devno, DWORD *FuncCtl);
		int SELDEV(DWORD addr, DWORD Busno, DWORD Devno, DWORD *FuncCtl);
		//!#00C3, Mar/05/2013, Vincent,
		int ISNGSSDVALID();
		int NGSSDSLOTOFF();
		int NGSSDSLOTON(int slot);
		int NGSSDLEDGO(int slot);
		int NGSSDLEDNG(int slot);
		int NGSSDLEDOFF(int slot);	
		int NGSSDGETCD(int slot);		
		int NGSSDGETPSTS(int slot);		
		int NGSSDGETCLKREQ(int slot);	
		//!#00C6, Aug/07/2014, Vincent 
		int RETRAINDEV();
		int RETRAINDEV(DWORD addr);
		
};

//!#000B, Oct/09/2007, Kikimum for Dll export to Borland C

#ifdef __cplusplus
extern "C" {
#endif

		PEMDLL_API int   usecomport;
		PEMDLL_API char CPEMDLL_PEMIO_Name[24][16];

		PEMDLL_API int  __stdcall PETS_INIT();
		PEMDLL_API int  __stdcall PETS_INIT1(int comport);
		PEMDLL_API int  __stdcall PETS_INITEX();
		PEMDLL_API int  __stdcall PETS_INITEX1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_EXIT();
		PEMDLL_API int  __stdcall PETS_VALIDPEM(DWORD addr);
		PEMDLL_API int  __stdcall PETS_SELPEM(DWORD addr);

		PEMDLL_API int  __stdcall PETS_GETPNTYPE();
		PEMDLL_API int  __stdcall PETS_VALIDDEV();
		PEMDLL_API int  __stdcall PETS_SELDEVVD(DWORD Vid, DWORD Did, int index);
		PEMDLL_API int  __stdcall PETS_SELDEVSVD(DWORD Vid, DWORD Did, DWORD Svid, DWORD Sdid, int index);		// 2013/09/12, Add
		PEMDLL_API int  __stdcall PETS_SELDEVBD(DWORD Busno, DWORD Devno);  
		PEMDLL_API int  __stdcall PETS_SELDEVFUNC(DWORD Busno, DWORD Devno, DWORD* FuncCtl);  // !#00C2: 08/08/2012		
		PEMDLL_API int  __stdcall PETS_PON();
		PEMDLL_API int  __stdcall PETS_POFF();
		PEMDLL_API int  __stdcall PETS_GETPWRSTS();
		PEMDLL_API int  __stdcall PETS_CHKSHORT();
		PEMDLL_API int  __stdcall PETS_GET3V3V(double* volatge);
		PEMDLL_API int  __stdcall PETS_GET1V5V(double* volatge);
		PEMDLL_API int  __stdcall PETS_GET12V(double* volatge);
		PEMDLL_API int  __stdcall PETS_GET3V3I(double* current);
		PEMDLL_API int  __stdcall PETS_GET1V5I(double* current);
		PEMDLL_API int  __stdcall PETS_GET3V3IMAX(double* current);	//!#0004
		PEMDLL_API int  __stdcall PETS_GET1V5IMAX(double* current);	//!#0004
		PEMDLL_API int  __stdcall PETS_GET12I(double* current);
		PEMDLL_API int  __stdcall PETS_GETTEMP(DWORD devaddr, double* temp);	//!#0003

		PEMDLL_API int  __stdcall PETS_SET1V5ICAL();
		PEMDLL_API int  __stdcall PETS_SET3V3ICAL();
		PEMDLL_API int  __stdcall PETS_SET12ICAL();
		PEMDLL_API int  __stdcall PETS_SETUSECAL(int i);
		PEMDLL_API int  __stdcall PETS_GETUSECAL();

		PEMDLL_API int  __stdcall PETS_WINCHECK();
		PEMDLL_API int  __stdcall PETS_WINEN(int delaytime);
		PEMDLL_API int  __stdcall PETS_WINDIS(int delaytime);
		PEMDLL_API int  __stdcall PETS_CHECKCFG(char* logfile);
		PEMDLL_API int  __stdcall PETS_WAITCARDREMOVE();
		PEMDLL_API int  __stdcall PETS_WAITCARDPLUG();
		PEMDLL_API int  __stdcall PETS_CHECKCD();	//!#0005
		PEMDLL_API int  __stdcall PETS_LEDGO();
		PEMDLL_API int  __stdcall PETS_LEDNG();
		PEMDLL_API int  __stdcall PETS_LEDOFF();
		PEMDLL_API int  __stdcall PETS_BEEP(int freq, int time);
		PEMDLL_API int  __stdcall PETS_SETPONRST(int setting);	//!#0004

		PEMDLL_API int  __stdcall PETS_GETPNTYPE1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_VALIDDEV1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_SELDEVVD1(DWORD addr, DWORD Vid, DWORD Did, int index);
		PEMDLL_API int  __stdcall PETS_SELDEVSVD1(DWORD addr, DWORD Vid, DWORD Did, DWORD Svid, DWORD Sdid, int index);		// 2013/09/12, Add		
		PEMDLL_API int  __stdcall PETS_SELDEVBD1(DWORD addr, DWORD Busno, DWORD Devno);
		PEMDLL_API int  __stdcall PETS_SELDEVFUNC1(DWORD addr, DWORD Busno, DWORD Devno, DWORD* FuncCtl);  // !#00C2: 08/08/2012				
		PEMDLL_API int  __stdcall PETS_GETPWRSTS1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_CHKSHORT1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_GET3V3V1(DWORD addr, double* volatge);
		PEMDLL_API int  __stdcall PETS_GET1V5V1(DWORD addr, double* volatge);
		PEMDLL_API int  __stdcall PETS_GET12V1(DWORD addr, double* volatge);
		PEMDLL_API int  __stdcall PETS_GET3V3I1(DWORD addr, double* current);
		PEMDLL_API int  __stdcall PETS_GET1V5I1(DWORD addr, double* current);
		PEMDLL_API int  __stdcall PETS_GET3V3IMAX1(DWORD addr, double* current);	//!#0004
		PEMDLL_API int  __stdcall PETS_GET1V5IMAX1(DWORD addr, double* current);	//!#0004
		PEMDLL_API int  __stdcall PETS_GETTEMP1(DWORD addr, DWORD devaddr, double* temp); //!#0003

		PEMDLL_API int  __stdcall PETS_GET12I1(DWORD addr, double* current);
		PEMDLL_API int  __stdcall PETS_SET1V5ICAL1(DWORD addr); 

		PEMDLL_API int  __stdcall PETS_SET3V3ICAL1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_SET12ICAL1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_SETUSECAL1(DWORD addr, int i);
		PEMDLL_API int  __stdcall PETS_GETUSECAL1(DWORD addr);

		PEMDLL_API int  __stdcall PETS_PON1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_POFF1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_WINCHECK1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_WINEN1(DWORD addr, int delaytime);
		PEMDLL_API int  __stdcall PETS_WINDIS1(DWORD addr, int delaytime);
		PEMDLL_API int  __stdcall PETS_CHECKCFG1(DWORD addr, char* logfile);
		PEMDLL_API int  __stdcall PETS_WAITCARDREMOVE1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_WAITCARDPLUG1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_CHECKCD1(DWORD addr);	//!#0005
		PEMDLL_API int  __stdcall PETS_LEDGO1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_LEDNG1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_LEDOFF1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_BEEP1(DWORD addr, int freq, int time);
		PEMDLL_API int	__stdcall PETS_SETPONRST1(DWORD addr, int setting);	//!#0004

		PEMDLL_API void __stdcall PETS_GETLIBVER(int* major, int* minor);
		PEMDLL_API int	__stdcall PETS_GETPCIDEVCOUNT();
		PEMDLL_API int  __stdcall PETS_SELPCIDEV(int num);
		PEMDLL_API char*	__stdcall PETS_GETPCIDEVDESC();
		PEMDLL_API DWORD	__stdcall PETS_GETPCIDEVVID();
		PEMDLL_API DWORD	__stdcall PETS_GETPCIDEVDID();
		PEMDLL_API DWORD	__stdcall PETS_GETPCIDEVBUSNO();
		PEMDLL_API DWORD	__stdcall PETS_GETPCIDEVDEVNO();
		PEMDLL_API DWORD	__stdcall PETS_GETPCIDEVSVID();	//2013/09/12
		PEMDLL_API DWORD	__stdcall PETS_GETPCIDEVSDID();	//2013/09/12

		PEMDLL_API int  __stdcall PETS_GPIOSETUP(int pinno, int mode, int val);
		PEMDLL_API int  __stdcall PETS_GPIOOUTSET(int pinno);
		PEMDLL_API int  __stdcall PETS_GPIOOUTRESET(int pinno);
		PEMDLL_API int  __stdcall PETS_GPIOIN(int pinno);
		PEMDLL_API int  __stdcall PETS_GPIOGETSETUP(int pinno);

		PEMDLL_API int  __stdcall PETS_GPIOSETUP1(DWORD addr, int pinno, int mode, int val);
		PEMDLL_API int  __stdcall PETS_GPIOOUTSET1(DWORD addr, int pinno);
		PEMDLL_API int  __stdcall PETS_GPIOOUTRESET1(DWORD addr, int pinno);
		PEMDLL_API int  __stdcall PETS_GPIOIN1(DWORD addr, int pinno);
		PEMDLL_API int  __stdcall PETS_GPIOGETSETUP1(DWORD addr, int pinno);

		//!#0009, Mar/09/2007
		PEMDLL_API int  __stdcall PETS_PROBESMBCLKRISE(double* time);
		PEMDLL_API int  __stdcall PETS_PROBESMBCLKRISE1(DWORD addr, double* time);
		//!#000A, Apr/18/2007, Vincent
		PEMDLL_API int  __stdcall PETS_GET5V(double* volatge);
		PEMDLL_API int  __stdcall PETS_GET5VI(double* current);
		PEMDLL_API int  __stdcall PETS_GET5VIMAX(double* current);	
		PEMDLL_API int  __stdcall PETS_GET5V1(DWORD addr, double* volatge);
		PEMDLL_API int  __stdcall PETS_GET5VI1(DWORD addr, double* current);
		PEMDLL_API int  __stdcall PETS_GET5VIMAX1(DWORD addr, double* current);


		PEMDLL_API int  __stdcall PETS_WINEN21(DWORD addr, int delaytime);
		PEMDLL_API int  __stdcall PETS_WINEN2(int delaytime);
		PEMDLL_API int  __stdcall PETS_DEVRESCAN(int delaytime);

		PEMDLL_API int  __stdcall PETS_RESETLINKEDDEVICECOUNT();
		PEMDLL_API int  __stdcall PETS_ADDLINKEDDEVICEFUNC(unsigned long busnoi, unsigned long devnoi, unsigned long funcnoi);
		PEMDLL_API int  __stdcall PETS_UPDATELINKEDDEVICE();

		PEMDLL_API int  __stdcall PETS_RESETLINKEDDEVICECOUNT1(DWORD addr);
		PEMDLL_API int  __stdcall PETS_ADDLINKEDDEVICEFUNC1(DWORD addr, unsigned long busnoi, unsigned long devnoi, unsigned long funcnoi);
		PEMDLL_API int	__stdcall PETS_UPDATELINKEDDEVICE1(DWORD addr);

		//!#00B1, May/07/2008, Add
		PEMDLL_API int  __stdcall	GETFIRMVERA(DWORD addr, int* major, int* minor);
		PEMDLL_API int  __stdcall	GETFIRMVER(int* major, int* minor);
		//!#00B2, Jun/05/2008, Add
		PEMDLL_API int  __stdcall	PWRCTL_AUTO();
		PEMDLL_API int  __stdcall	PWRCTL_MANUAL();
		PEMDLL_API int  __stdcall	PWRCTL_AUTOA(DWORD addr);
		PEMDLL_API int  __stdcall	PWRCTL_MANUALA(DWORD addr);

		//!#00C1: IO Conttrol FOR PEM IOM V1.01
		PEMDLL_API int __stdcall	PETS_IOMINIT();
		PEMDLL_API int __stdcall	PETS_IOMGETPINOE(int pinno);
		PEMDLL_API int __stdcall	PETS_IOMGETPINIE(int pinno);
		PEMDLL_API int __stdcall	PETS_IOMSETPINOE(int pinno);
		PEMDLL_API int __stdcall	PETS_IOMSETPINIE(int pinno);
		PEMDLL_API int __stdcall	PETS_IOMSETPIN(int pinno, int hilo);
		PEMDLL_API int __stdcall	PETS_IOMGETPIN(int pinno);
		PEMDLL_API char* __stdcall	PETS_IOMGETPINNAME(int pinno);
		PEMDLL_API int __stdcall	PETS_IOMSETPINPU(int pinno, int hilo);
		PEMDLL_API int __stdcall	PETS_IOMGETPINPU(int pinno);

		PEMDLL_API int __stdcall	PETS_IOMSETOE(unsigned long val);
		PEMDLL_API int __stdcall	PETS_IOMSETIO(unsigned long val);
		PEMDLL_API int __stdcall	PETS_IOMSETPU(unsigned long val);
		PEMDLL_API int __stdcall	PETS_IOMGETIO(unsigned long *val);
		PEMDLL_API int __stdcall	PETS_IOMGETPU(unsigned long *val);
		PEMDLL_API int __stdcall	PETS_IOMGETOE(unsigned long *val);

		//!#00C3, Mar/05/2013, Vincent,
		PEMDLL_API int __stdcall	NGSSDSLOTOFF();
		PEMDLL_API int __stdcall	NGSSDSLOTON(int slot);
		PEMDLL_API int __stdcall	NGSSDLEDGO(int slot);
		PEMDLL_API int __stdcall	NGSSDLEDNG(int slot);
		PEMDLL_API int __stdcall	NGSSDLEDOFF(int slot);	
		PEMDLL_API int __stdcall	NGSSDGETCD(int slot);		
		PEMDLL_API int __stdcall	NGSSDGETPSTS(int slot);		
		PEMDLL_API int __stdcall	NGSSDGETCLKREQ(int slot);
		PEMDLL_API int __stdcall	ISNGSSDVALID();


		PEMDLL_API DWORD __stdcall PETS_GETDEVHWVID();
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWDID();
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWSVID();
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWSDID();		
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWVID1(DWORD addr);
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWDID1(DWORD addr);
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWSVID1(DWORD addr);
		PEMDLL_API DWORD __stdcall PETS_GETDEVHWSDID1(DWORD addr);	
		
		//!#00C6, Aug/07/2014, Vincent 
		PEMDLL_API int __stdcall PETS_RETRAINDEV();
		PEMDLL_API int __stdcall PETS_RETRAINDEVA(DWORD addr);
		

#ifdef __cplusplus
}
#endif
